# MySQL dump 8.14
#
# Host: localhost    Database: store
#--------------------------------------------------------
# Server version	3.23.39

#
# Table structure for table 'addresses'
#
create database store;
use store;

CREATE TABLE addresses (
  address_id int(11) NOT NULL auto_increment,
  user_id int(11) default NULL,
  place varchar(25) NOT NULL default '',
  addr_1 varchar(255) NOT NULL default '',
  addr_2 varchar(255) default NULL,
  city varchar(50) NOT NULL default '',
  state char(2) NOT NULL default '',
  ZIP varchar(5) NOT NULL default '',
  country varchar(5) default NULL,
  PRIMARY KEY  (address_id)
) TYPE=MyISAM;

#
# Dumping data for table 'addresses'
#

INSERT INTO addresses VALUES (1,1,'home','1313 Mockingbird Ln','Apt 2','New York','NY','22222','USA');
INSERT INTO addresses VALUES (2,1,'work','254 Foo Lane','Ste 2','Hoboken','NY','44555','USA');
INSERT INTO addresses VALUES (3,2,'home','17 Maple Rd',NULL,'Setauket','CA','11733','USA');
INSERT INTO addresses VALUES (4,2,'work','2020 Wall St','Ste 25','New York','NY','11144','USA');
INSERT INTO addresses VALUES (5,3,'home','1845 Fair Oaks','Apt 6','San Francisco','CA','92147','USA');
INSERT INTO addresses VALUES (6,4,'home','30445 Haines St','Apt 8G','San Francisco','CA','92149','USA');
INSERT INTO addresses VALUES (7,5,'home','8 Oak Rd',NULL,'Atlanta','GA','14119','USA');

#
# Table structure for table 'formats'
#

CREATE TABLE formats (
  formats char(35) NOT NULL default '',
  PRIMARY KEY  (formats)
) TYPE=MyISAM;

#
# Dumping data for table 'formats'
#

INSERT INTO formats VALUES ('Book');
INSERT INTO formats VALUES ('Magazine Article');
INSERT INTO formats VALUES ('Web Article');
INSERT INTO formats VALUES ('Web Articles');
INSERT INTO formats VALUES ('Whitepaper');

#
# Table structure for table 'items_for_sale'
#

CREATE TABLE items_for_sale (
  item_id int(11) NOT NULL auto_increment,
  product_id int(11) NOT NULL default '0',
  format char(35) NOT NULL default '',
  price decimal(6,2) NOT NULL default '0.00',
  PRIMARY KEY  (item_id)
) TYPE=MyISAM;

#
# Dumping data for table 'items_for_sale'
#

INSERT INTO items_for_sale VALUES (1,1,'book',19.95);
INSERT INTO items_for_sale VALUES (2,2,'Whitepaper',12.99);
INSERT INTO items_for_sale VALUES (3,1,'BOOK',49.95);

#
# Table structure for table 'order_items'
#

CREATE TABLE order_items (
  order_items_id int(11) NOT NULL auto_increment,
  order_id int(11) NOT NULL default '0',
  item_id int(11) NOT NULL default '0',
  price decimal(10,2) NOT NULL default '0.00',
  last_update timestamp(14) NOT NULL,
  PRIMARY KEY  (order_items_id)
) TYPE=MyISAM;

#
# Dumping data for table 'order_items'
#

INSERT INTO order_items VALUES (1,1,1,25.00,20010920143305);
INSERT INTO order_items VALUES (2,1,2,12.99,20010920143305);
INSERT INTO order_items VALUES (3,2,2,14.99,20010921105145);
INSERT INTO order_items VALUES (4,2,3,25.99,20010921105737);
INSERT INTO order_items VALUES (5,2,2,14.99,20010921110308);

#
# Table structure for table 'orders'
#

CREATE TABLE orders (
  order_id int(11) NOT NULL auto_increment,
  user_id int(11) NOT NULL default '0',
  order_total decimal(10,2) NOT NULL default '0.00',
  time_of_order timestamp(14) not null,
  PRIMARY KEY  (order_id)
) TYPE=MyISAM;

#
# Dumping data for table 'orders'
#

INSERT INTO orders VALUES (1,1,45.00);
INSERT INTO orders VALUES (2,3,19.95);

#
# Table structure for table 'places'
#

CREATE TABLE places (
  place char(25) NOT NULL default '',
  PRIMARY KEY  (place)
) TYPE=MyISAM;

#
# Dumping data for table 'places'
#

INSERT INTO places VALUES ('home');
INSERT INTO places VALUES ('work');

#
# Table structure for table 'products'
#

CREATE TABLE products (
  product_id int(11) NOT NULL auto_increment,
  product_name varchar(75) NOT NULL default '',
  product_description text NOT NULL,
  PRIMARY KEY  (product_id)
) TYPE=MyISAM;

#
# Dumping data for table 'products'
#

INSERT INTO products VALUES (1,'MySQL Weekend Crash Course','A quick but complete introduction to a great open source database.');
INSERT INTO products VALUES (2,'PHP for the Web','A technical introduction to a popular open source scripting language.');
INSERT INTO products VALUES (3,'MySQL/PHP Database Applications','A guide to this great opens source pair');

#
# Table structure for table 'users'
#

CREATE TABLE users (
  user_id int(11) NOT NULL auto_increment,
  fname varchar(25) NOT NULL default '',
  lname varchar(25) default NULL,
  email varchar(60) default NULL,
  home_phone varchar(14) default NULL,
  work_phone varchar(14) default NULL,
  fax varchar(14) default NULL,
  last_update timestamp(14) NOT NULL,
  PRIMARY KEY  (user_id),
  KEY index_on_email (email)
) TYPE=MyISAM;

#
# Dumping data for table 'users'
#

INSERT INTO users VALUES (1,'Jon','Doe','jdoe@jdoe.com','2125554444','2025554444','2035556666',20010920143336);
INSERT INTO users VALUES (2,'Ed','Fromlin','efromlin@eddief.com','4155556666','2025555555','',20010920143336);
INSERT INTO users VALUES (5,'Elliot','Krug','ekrug@kruger.com','1112223333','4445556666','7778889999',20010920143336);
INSERT INTO users VALUES (4,'Jay','Greenspan','jay@trans-city.com','7185551212','7185552323','7185558989',20010920143336);
INSERT INTO users VALUES (6,'Willy','Krug','wkrug@kruger.com','1112228888','4445557777','777888000',20010920143336);

